/**
 * Custom error class for AI Pipeline errors
 */
export class PipelineError extends Error {
    /**
     * @param {string} message Error message
     * @param {string} code Error code
     * @param {Error} [cause] Original error that caused this error
     */
    constructor(message, code, cause) {
        super(message);
        this.name = 'PipelineError';
        this.code = code;
        this.cause = cause;
        this.timestamp = new Date().toISOString();
    }

    /**
     * Creates an initialization error
     * @param {string} message Error message
     * @param {Error} [cause] Original error
     * @returns {PipelineError}
     */
    static initialization(message, cause) {
        return new PipelineError(message, 'INITIALIZATION_ERROR', cause);
    }

    /**
     * Creates a configuration error
     * @param {string} message Error message
     * @param {Error} [cause] Original error
     * @returns {PipelineError}
     */
    static configuration(message, cause) {
        return new PipelineError(message, 'CONFIGURATION_ERROR', cause);
    }

    /**
     * Creates an operation error
     * @param {string} message Error message
     * @param {Error} [cause] Original error
     * @returns {PipelineError}
     */
    static operation(message, cause) {
        return new PipelineError(message, 'OPERATION_ERROR', cause);
    }
}