/**
 * Cleanup resources associated with this service
 */
export async function cleanup(active_vector_stores, client) {
    const cleanup_promises = Array.from(active_vector_stores.entries())
        .map(async ([id, store]) => {
            try {
                await client.beta.vectorStores.delete(id);
                active_vector_stores.delete(id);
            } catch (error) {
                console.error(`Failed to cleanup vector store ${id}:`, error);
            }
        });

    await Promise.allSettled(cleanup_promises);
}