import fs from 'fs/promises';

/**
 * Upload a file to OpenAI
 * @param {string} file_path Path to the file
 * @param {OpenAI} client OpenAI client
 * @param {number} maxFileSize Maximum file size in bytes
 * @param {function} withRetry Retry function
 * @param {number} maxRetries Maximum retry attempts
 * @param {number} retryDelay Delay between retries in milliseconds
 * @returns {Promise<Object>} Uploaded file information
 */
export async function uploadFile(file_path, client, maxFileSize, withRetry, maxRetries, retryDelay) {
    const stats = await fs.stat(file_path);
    if (stats.size > maxFileSize) {
        throw new Error('File exceeds OpenAI size limit of 25MB');
    }

    return await withRetry(async () => {
        const file_stream = await fs.readFile(file_path);
        return await client.files.create({
            file: file_stream,
            purpose: 'assistants'
        });
    }, maxRetries, retryDelay);
}