import path from "path";
import os from "os";
import fs from "fs";
import { openai } from "../config/pipeline-config.js";

// Helper function to perform transcription and return text
export async function transcribeAudioInternal(fileBuffer) {
  const tempFilePath = path.join(os.tmpdir(), `whisper-${Date.now()}.mp3`);
  try {
    await fs.promises.writeFile(tempFilePath, fileBuffer);
    const transcription = await openai.audio.transcriptions.create({
      file: fs.createReadStream(tempFilePath),
      model: "whisper-1",
    });
    await fs.promises.unlink(tempFilePath);
    return transcription.text;
  } catch (error) {
    await fs.promises.unlink(tempFilePath);
    throw error;
  }
}

export async function transcribeAudio(req, res) {
  // try {
  if (!req.file) {
    return res.status(400).json({
      success: false,
      error: "No audio file provided",
    });
  }
  const text = await transcribeAudioInternal(req.file.buffer);
  return text;
  // } catch (error) {
  //   return res.status(500).json({
  //     success: false,
  //     error: error.message,
  //   });
  // }
}

export async function synthesizeSpeech(req, res) {
  try {
    const { text, voice = "alloy" } = req.body;
    const mp3 = await openai.audio.speech.create({
      model: "tts-1",
      voice: voice,
      input: text,
    });

    const buffer = Buffer.from(await mp3.arrayBuffer());
    res.setHeader("Content-Type", "audio/mpeg");
    return res.send(buffer);
  } catch (error) {
    return res.status(500).json({
      success: false,
      error: error.message,
    });
  }
}
