import arabic_reshaper
from bidi.algorithm import get_display

def test_persian_processing():
    # Sample Persian text for testing
    text = """
    به نام خدا
    این یک متن آزمایشی است.
    برای تست پردازش متن فارسی.
    """
    
    try:
        print("Original text:")
        print(text)
        print("-" * 50)
        
        # Handle RTL display
        reshaped_text = arabic_reshaper.reshape(text)
        bidi_text = get_display(reshaped_text)
        print("RTL formatted text:")
        print(bidi_text)
        
        return True
    except Exception as e:
        print(f"Error: {str(e)}")
        return False

if __name__ == "__main__":
    success = test_persian_processing()
    print(f"\nTest {'succeeded' if success else 'failed'}")