import dotenv from "dotenv";

dotenv.config();

const PORT = process.env.PORT || 7000;

export const authConfig = {
  jwtSecret: process.env.JWT_SECRET_KEY,
  allowedOrigins: [
    `https://${process.env.METABOARD_DOMAIN}`,
    `https://www.${process.env.METABOARD_DOMAIN}`,
    "http://localhost:3000/",
    "http://localhost:6015/",
    "http://192.168.10.119:3000",
    "http://192.168.10.119:3000/",
  ],
  jwtExpiresIn: "90d",
};
