# System Flowcharts

## File Processing Pipeline

```mermaid
flowchart TD
    A[Client Upload] -->|Upload Request| B[File Validation]
    B -->|Valid File| C[File Storage]
    C -->|Stored Successfully| D[Document Processing]
    D -->|PDF/DOC| E[Text Extraction]
    D -->|Excel| F[Data Processing]
    D -->|Persian Files| G[Persian Processing]
    E --> H[Content Analysis]
    F --> H
    G --> H
    H -->|Processed Data| I[Store Results]

    B -->|Invalid File| X[Error Response]
    C -->|Storage Failed| X
    style X fill:#ff9999
```

## Authentication Flow

```mermaid
sequenceDiagram
    participant User
    participant Auth
    participant SMS
    participant DB

    User->>Auth: Request Authentication
    Auth->>SMS: Send Verification Code
    SMS-->>User: SMS with Code
    User->>Auth: Submit Code
    Auth->>DB: Verify Code
    DB-->>Auth: Validation Result
    Auth-->>User: Auth Token/Error
```

## Document Processing Architecture

```mermaid
graph TB
    subgraph Frontend
    A[User Interface]
    end

    subgraph Backend Services
    B[API Gateway]
    C[File Service]
    D[Agent Service]
    E[OpenAI Service]
    end

    subgraph Processing Pipeline
    F[Document Processor]
    G[Persian Processor]
    H[File Analysis]
    end

    A -->|Upload| B
    B -->|Route| C
    C -->|Process| F
    F -->|Persian Text| G
    F -->|Analysis| H
    F -->|AI Processing| D
    D -->|API Calls| E
```

## Service Dependencies

```mermaid
erDiagram
    FileService ||--o{ DocumentProcessor : uses
    DocumentProcessor ||--o{ PersianProcessor : "uses for Persian"
    AgentService ||--o{ OpenAIService : integrates
    FileService ||--o{ FileValidation : validates
    AgentService ||--o{ FileAnalysis : analyzes
    FileService ||--o{ QueueStatus : tracks
```

## File Processing States

```mermaid
stateDiagram-v2
    [*] --> Uploaded
    Uploaded --> Validating
    Validating --> Processing
    Validating --> Failed
    Processing --> Analyzing
    Analyzing --> Completed
    Analyzing --> Failed
    Failed --> [*]
    Completed --> [*]
```

Each diagram shows a different aspect of the system:

- The File Processing Pipeline shows the overall flow of file handling
- Authentication Flow demonstrates the SMS verification process
- Document Processing Architecture shows system components and their interactions
- Service Dependencies illustrates relationships between different services
- File Processing States shows the possible states of a file in the system
