import swaggerJsdoc from "swagger-jsdoc";
import { fileURLToPath } from "url";
import { dirname, join } from "path";
import dotenv from "dotenv";
import { AgentSwaggerDocs } from "../AI-PipeLine/docs/agent.swagger.js";
import { InvoiceSwaggerDocs } from "./invoice.swagger.js";


dotenv.config();

const PORT = process.env.PORT || 7000;
const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

const options = {
  definition: {
    openapi: "3.0.0",
    info: {
      title: "Metaboard Backend API",
      version: "1.0.0",
      description:
        "API documentation for the entire Metaboard backend, including authentication, user management, and AI Pipeline features.",
    },
    servers: [
      {
        url: process.env.API_URL || `http://localhost:${PORT}`,
        description: "Development server",
      },
    ],
    tags: [
      { name: "Authentication", description: "Auth routes (login, signup, etc.)" },
      { name: "AI Pipeline", description: "File ingestion, analysis, agent creation, agent chat and batch operations" },
      { name: "Upload", description: "Universal file upload system" },
      { name: "User", description: "User management routes" },
      { name: "Languages", description: "Language management and retrieval endpoints" },
    ],
    components: {
      securitySchemes: {
        BearerAuth: {
          type: "http",
          scheme: "bearer",
          bearerFormat: "JWT",
        },
      },
      responses: {
        BadRequest: {
          description: "Invalid request parameters",
          content: {
            "application/json": {
              schema: {
                type: "object",
                properties: {
                  error: { type: "string", example: "Invalid input data provided" },
                },
              },
            },
          },
        },
        NotFound: {
          description: "Requested resource not found",
          content: {
            "application/json": {
              schema: {
                type: "object",
                properties: {
                  error: { type: "string", example: "Resource not found" },
                },
              },
            },
          },
        },
        ServerError: {
          description: "Internal server error",
          content: {
            "application/json": {
              schema: {
                type: "object",
                properties: {
                  error: { type: "string", example: "An unexpected error occurred" },
                },
              },
            },
          },
        },
      },
    },
    security: [{ BearerAuth: [] }],
  },
  apis: [
    // Only include route files where we have API documentation
    join(__dirname, "../routes/*.js"),
    join(__dirname, "../AI-PipeLine/routes/*.js"),
    // Removing join for docs/*.js because we merge AgentSwaggerDocs manually below
  ],
};

const swaggerSpec = swaggerJsdoc(options);
// Merge external API definitions into the generated spec
swaggerSpec.paths = {
  ...swaggerSpec.paths,
  ...AgentSwaggerDocs,
  ...InvoiceSwaggerDocs,
};

export const swaggerSpecs = swaggerSpec;
