import mongoose from "mongoose";

const BoothEnumsSchema = new mongoose.Schema(
  {
    exhibition_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "exhibitions",
    },
    poster_number: {
      type: Number,
    },
    agent_number: {
      type: Number,
    },
    monitor_number: {
      type: Number,
    },
    stand_number: {
      type: Number,
    },
    video_wall_number: {
      type: Number,
    },
    prefab_id: {
      type: String,
    },
    preview_image: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    floor_1: {
      type: Number,
      default: 0,
    },
    floor_2: {
      type: Number,
      default: 0,
    },
    floor_3: {
      type: Number,
      default: 0,
    },
    index: {
      type: Number,
      default: 0,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const BoothEnumsModel = mongoose.model("booth_enums", BoothEnumsSchema);
