import mongoose from "mongoose";

const BoughtenBoothsSchema = new mongoose.Schema(
  {
    exhibition_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "exhibitions",
    },
    booth_enum_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "booth_enums",
    },
    floor: {
      type: Number,
    },
    owner: {
      type: String,
      required: true,
    },
    owner_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    creator_name: {
      type: String,
    },
    name: {
      type: String,
    },
    description: {
      type: String,
    },
    start_date: {
      type: Date,
      default: Date.now,
      required: true,
    },
    end_date: {
      type: Date,
      default: null,
    },
    path: {
      type: String,
    },
    logo: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    color_enum_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "color_enums",
    },
    active: {
      type: Boolean,
      default: false,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

// Add indexes for commonly queried fields
BoughtenBoothsSchema.index({ exhibition_id: 1 });
BoughtenBoothsSchema.index({ is_removed: 1 });

export const BoughtenBoothsModel = mongoose.model(
  "boughten_booths",
  BoughtenBoothsSchema
);
