import mongoose from "mongoose";

const ConfigSchema = new mongoose.Schema(
  {
    language_version: {
      type: Number,
    },
    web_status: {
      type: String,
      enum: ["live", "updating"],
    },
    metaverse_status: {
      type: String,
      enum: ["live", "updating"],
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
    owners: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: "users",
      },
    ],
  },
  {
    timestamps: true,
  }
);

export const ConfigModel = mongoose.model("configs", ConfigSchema);
