import mongoose from "mongoose";

const CurrenciesSchema = new mongoose.Schema(
  {
    symbol: {
      type: String,
      required: true,
      index: true,
    },
    title: {
      type: String,
      required: true,
    },
    country: {
      type: String,
      required: true,
    },
    is_removed: {
      type: Boolean,
      default: false,
    },
    currency_symbol: {
      type: String,
    },
    icon: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
  },
  {
    timestamps: true,
  }
);

export const CurrenciesModel = mongoose.model("currencies", CurrenciesSchema);
