import mongoose from "mongoose";

const ExhibitionsSchema = new mongoose.Schema(
  {
    name: {
      type: String,
    },
    description: {
      type: String,
    },
    category_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "exhibitions_categories",
    },
    path: {
      type: String,
    },
    scene_name: {
      type: String,
    },
    creator_name: {
      type: String,
    },
    logo: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    website: {
      type: String,
    },

    is_physical: {
      type: Boolean,
    },
    address: {
      type: String,
    },
    banner: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    video: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    start_date: {
      type: Date,
    },
    end_date: {
      type: Date,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const ExhibitionsModel = mongoose.model(
  "exhibitions",
  ExhibitionsSchema
);
