import mongoose from "mongoose";

const InvoiceSchema = new mongoose.Schema(
  {
    ref: {
      type: String,
      required: true,
    },
    ref_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    hash: {
      type: String,
      required: false,
    },
    payment_method_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    amount: {
      type: Number,
      required: true,
    },
    discount: {
      type: Number,
      required: true,
      default: 0,
    },
    tax: {
      type: Number,
      required: true,
      default: 0,
    },
    status: {
      type: String,
      enum: ["pending", "paid", "failed"],
      default: "pending",
    },
    is_removed: {
      type: Boolean,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const InvoiceModel = mongoose.model("invoices", InvoiceSchema);
