import mongoose from "mongoose";

const meetingSchema = new mongoose.Schema(
    {
        booth_id: { type: mongoose.Types.ObjectId, required: true, ref: "BoughtenBooths" },
        user_id: { type: mongoose.Types.ObjectId, required: true, ref: "User" },  // کسی که رزرو کرده
        start_time: { type: Date, required: true },
        end_time: { type: Date, required: true },
        link: { type: String, required: false },  // لینک جلسه مثل Zoom یا ...
        is_canceled: { type: Boolean, default: false },
    },
    { timestamps: true }
);

export const MeetingModel = mongoose.model("Meeting", meetingSchema);
