import mongoose from "mongoose";

const OrganizationsSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true,
    },
    type: {
      type: String,
      required: true,
    },
    register_number: {
      type: String,
      required: true,
    },
    national_id: {
      type: String,
      required: true,
    },
    representative_id: {
      type: String,
      required: true,
    },
    verify_phone: {
      type: Boolean,
      required: true,
    },
    email: {
      type: String,
      required: true,
    },
    logo: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const OrganizationsModel = mongoose.model(
  "organizations",
  OrganizationsSchema
);
