import mongoose from "mongoose";

const PaymentMethodSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true,
    },
    currency_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "currencies",
    },
    network: {
      type: String,
    },
    address: {
      type: String,
    },
    is_removed: {
      type: Boolean,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const PaymentMethodModel = mongoose.model(
  "payment_methods",
  PaymentMethodSchema
);
