import mongoose from "mongoose";

const RateLimitSchema = new mongoose.Schema({
  ip: { type: String, required: true },
  requests: { type: Number, default: 1 },
  timestamp: { type: Date, default: Date.now }
});

// Add index to automatically expire documents after 1 minute
RateLimitSchema.index({ timestamp: 1 }, { expireAfterSeconds: 60 });

export const RateLimitModel = mongoose.model("ratelimits", RateLimitSchema);