import mongoose from "mongoose";

const SettingSchema = new mongoose.Schema(
  {
    title: { type: String, required: true },
    symbol: { type: String },
    country: { type: String },
    icon: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "files",
    },
    is_removed: { type: Boolean, default: false },
  },
  { timestamps: true }
);

export const SettingModel = mongoose.model("setting", SettingSchema);
