import mongoose from "mongoose";

const UserSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      trim: true,
      default: "",
    },
    phone: {
      type: String,
      required: true,
      unique: true,
      trim: true,
      validate: {
        validator: function (v) {
          return /^(\+98|0)?9\d{9}$/.test(v);
        },
        message: (props) =>
          `${props.value} is not a valid Iranian phone number!`,
      },
    },
    balance: {
      type: Number,
      default: 0,
    },
    national_code: {
      type: String,
      required: false,
      unique: true,
      validate: {
        validator: function (v) {
          return v === null || v === undefined || v !== "";
        },
        message: "National code cannot be an empty string.",
      },
    },
    metaboard_access: {
      type: Boolean,
      required: false,
      default: false,
    },
    admin_access: {
      type: Boolean,
      required: false,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const UserModel = mongoose.model("users", UserSchema);
