import path from "path";

/**
 * Build the final directory path for file upload based on ref type and related IDs
 * @param {string} basePath - Base upload path
 * @param {string} ref - Reference type
 * @param {string} ref_id - Reference ID
 * @param {Object} relatedIds - Related IDs from getRelatedIds
 * @param {Object} file - File object with mimetype
 * @returns {string} Final directory path
 */
export function buildFinalDirectory(
  basePath,
  ref,
  ref_id,
  relatedIds,
  file = null
) {
  switch (ref) {
    case "organizations":
      return path.join(basePath, "organizations", ref_id);
    case "users":
      return path.join(basePath, "users", ref_id);

    case "exhibitions":
      return path.join(basePath, "exhibitions", ref_id);

    case "agents":
      return path.join(basePath, "agents", ref_id, "raw_files");

    case "boughten_booths": {
      const { exhibition_id } = relatedIds;
      return path.join(
        basePath,
        "exhibitions",
        exhibition_id,
        "boughten_booths",
        ref_id
      );
    }

    case "video_walls":
    case "posters":
    case "monitors":
    case "stands": {
      const { booth_id, exhibition_id } = relatedIds;
      return path.join(
        basePath,
        "exhibitions",
        exhibition_id,
        "boughten_booths",
        booth_id,
        ref
      );
    }

    default:
      throw new Error(`Invalid ref type: ${ref}`);
  }
}
