export const isIranianMobilePhone = (value) => {
  const iranianMobilePhonePattern = /^(\+98|0)?9\d{9}$/;
  return iranianMobilePhonePattern.test(value);
};

export const isJSON = (body) => {
  try {
    JSON.parse(body);
    return true;
  } catch (e) {
    return false;
  }
};

export const isInt = (body) => {
  try {
    parseInt(body);
    return true;
  } catch {
    return false;
  }
};

export const generateVerificationCode = () => {
  return Math.floor(1000 + Math.random() * 9000);
};

export const validateAuthRequest = (errors) => {
  if (!errors.isEmpty()) {
    return {
      isValid: false,
      error: {
        status: 400,
        data: null,
        ...errors,
        message: "validation error"
      }
    };
  }
  return { isValid: true };
};